/*******************************************************************************
 mod_streaming_export.h

 Copyright (C) 2009-2023 CodeShop B.V.
 http://www.code-shop.com

 For licensing see the LICENSE file
******************************************************************************/

#ifndef MOD_STREAMING_EXPORT_H_AKW
#define MOD_STREAMING_EXPORT_H_AKW

#if defined _WIN32 || defined __CYGWIN__
# define MOD_STREAMING_DLL_IMPORT __declspec(dllimport)
# define MOD_STREAMING_DLL_EXPORT __declspec(dllexport)
# define MOD_STREAMING_DLL_LOCAL
#else
# if __GNUC__ >= 4
#   define MOD_STREAMING_DLL_IMPORT __attribute__ ((visibility("default")))
#   define MOD_STREAMING_DLL_EXPORT __attribute__ ((visibility("default")))
#   define MOD_STREAMING_DLL_LOCAL  __attribute__ ((visibility("hidden")))
# else
#   define MOD_STREAMING_DLL_IMPORT
#   define MOD_STREAMING_DLL_EXPORT
#   define MOD_STREAMING_DLL_LOCAL
# endif
#endif

#if defined(BUILDING_MP4SPLIT)
#  if defined(MP4_STATIC)
#    define MP4_DLL_EXPORT
#  else
#    define MP4_DLL_EXPORT MOD_STREAMING_DLL_EXPORT
#  endif
#else
#  if defined(MP4_STATIC)
#    define MP4_DLL_EXPORT
#  else
#    define MP4_DLL_EXPORT MOD_STREAMING_DLL_IMPORT
#  endif
#endif

#if !defined(MP4_DLL_LOCAL)
#  define MP4_DLL_LOCAL MOD_STREAMING_DLL_LOCAL
#endif

#define USP_STRINGIFY_HELPER(str) #str
#define USP_STRINGIFY(str) USP_STRINGIFY_HELPER(str)

#define USP_CONCAT_HELPER(x,y) x ## y
#define USP_CONCAT(x, y) USP_CONCAT_HELPER(x, y)

#define MOD_SMOOTH_STREAMING_VERSION_MAJOR      1
#define MOD_SMOOTH_STREAMING_VERSION_MINOR      12
#define MOD_SMOOTH_STREAMING_VERSION_REVISION   1

#define X_MOD_SMOOTH_STREAMING_KEY         "X-Mod-Smooth-Streaming"

// This repeats the #defines above, but it is grepped for...
#define X_MOD_SMOOTH_STREAMING_VERSION     "version=1.12.1"

#ifdef __cplusplus
#define __STDC_FORMAT_MACROS    // C++ should define this for PRIu64
#define __STDC_LIMIT_MACROS     // C++ should define this for UINT64_MAX
#define __STDC_CONSTANT_MACROS  // C++ should define this for INT64_C
#endif

#if defined(_MSC_VER) && _MSC_VER < 1900
# define snprintf _snprintf
#endif

#if defined(__cplusplus) && __cplusplus >= 201703L
#  define MP4_NODISCARD [[nodiscard]]
#elif defined(__GNUC__) // also works for clang
#  define MP4_NODISCARD __attribute__((__warn_unused_result__))
#elif defined(_MSC_VER)
// Unfortunately MSVC's _Check_return only works in "Code Analysis" mode, not
// during regular compilation, and you also need to include <sal.h> to be able
// to use it.
#  define MP4_NODISCARD// _Check_return_
#else
#  define MP4_NODISCARD
#endif

#ifdef __cplusplus
extern "C" {
#endif

MP4_DLL_EXPORT char const* fmp4_version_string();

#ifdef __cplusplus
} /* extern C definitions */
#endif

#endif // MOD_STREAMING_EXPORT_H_AKW

// End Of File

